<?php

namespace Mtc\Import\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\App;

/**
 * Class RunImport
 *
 * @package Mtc\Import
 */
class RunImport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run the import script for the given config';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        App::make(config('import.driver'))->import($this);
    }
}
