<?php

namespace Mtc\Import\Providers;

use Mtc\Import\Console\Commands\RunImport;
use Illuminate\Support\ServiceProvider;

/**
 * Class ImportServiceProvider
 *
 * @package Mtc\Import
 */
class ImportServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/import.php', 'import');
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/import.php' => config_path('import.php'),
            ], 'config');

            // Registering package commands.
            $this->commands([
                RunImport::class,
            ]);
        }
    }

}
