<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Import driver
    |--------------------------------------------------------------------------
    |
    | Select import driver that will be used to import data
    |
    */

    'driver' => \Mtc\Import\Drivers\MtcV1::class,
    //'driver' => \Mtc\Import\Drivers\Wordpress::class,

    /*
    |--------------------------------------------------------------------------
    | Import config
    |--------------------------------------------------------------------------
    |
    | Define the config for importing data
    | This allows setting which parts to import as well as defining
    | credentials for remote database
    |
    */

    'config' => [
        'truncate' => false,
        'import_members' => false,
        'import_categories' => false,
        'import_items' => false,
        'import_item_images' => false,
        'import_orders' => false,
        'import_refunds' => false,
        'link_past_order_items' => false,
        'db_host' => env('IMPORT_DB_HOST', ''),
        'db_user' => env('IMPORT_DB_USER', ''),
        'db_pass' => env('IMPORT_DB_PASSWORD', ''),
        'db_name' => env('IMPORT_DB_NAME', ''),
    ]
];