<?php

namespace Mtc\Insights;

use Mtc\Insights\Contracts\InsightMapInterface;

/**
 * Class InsightService
 *
 * @package Mtc\Insights
 */
class InsightService
{
    protected $api;

    /**
     * InsightService constructor.
     * @param InsightApi $api
     */
    public function __construct(InsightMapInterface $map, InsightApi $api)
    {
        $this->api = $api;
        $this->map = $map;
    }

    /**
     * Run the service reporting
     */
    public function run()
    {
        return $this->report($this->gatherData());
    }

    /**
     * Gather data to report
     *
     * return array
     */
    protected function gatherData()
    {
        return [
            'packages' => $this->map->packages(),
            'settings' => $this->map->settings(),
            'components' => $this->map->components(),
        ];
    }

    /**
     * Report site data to the Insight API
     * @param $data
     */
    protected function report($data)
    {
        return $this->api->send($this->getSiteUrl(), $data);
    }

    /**
     * Get the current sites url
     *
     * @return \Illuminate\Config\Repository|mixed
     */
    protected function getSiteUrl()
    {
        return config('app.url');
    }
}