<?php

namespace Mtc\Insights;

/**
 * Class InsightApi
 *
 * @package Mtc\Insights
 */
class SmartSchedule
{
    /**
     * Load the schedule
     *
     * @return object
     * @throws \Exception
     */
    public function loadSchedule()
    {
        if ($this->scheduleExists() === false) {
            $this->createSchedule();
        }

        return $this->fetchSchedule();
    }

    /**
     * Check if schedule exists
     *
     * @return bool
     */
    protected function scheduleExists(): bool
    {
        return file_exists($this->getScheduleFilePath());
    }

    /**
     * Build up a schedule file to
     * @throws \Exception
     */
    protected function createSchedule()
    {
        $weekday = random_int(1, 7);
        $hour_of_day = str_pad((string)random_int(0, 23), 2, '0');
        $minute_of_day = str_pad((string)random_int(0, 59), 2, '0');

        $data = [
            'weekday' => $weekday,
            'time' => $hour_of_day . ':' . $minute_of_day
        ];

        file_put_contents($this->getScheduleFilePath(), json_encode($data));
    }

    /**
     * Get the schedule config
     *
     * @return object
     */
    protected function fetchSchedule()
    {
        return json_decode(file_get_contents($this->getScheduleFilePath()));
    }

    /**
     * Get the path to the schedule file
     *
     * @return string
     */
    protected function getScheduleFilePath()
    {
        return storage_path('framework/.insights-schedule');
    }
}