<?php

namespace Mtc\Insights\Tests\Unit;

use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Response;
use Mtc\Insights\InsightApi;
use Orchestra\Testbench\TestCase as OrchestraTestbench;

/**
 * Class CurrencyTest
 *
 * @package Mtc\Insights\Tests\Unit
 */
class InsightApiTest extends OrchestraTestbench
{
    /**
     * @var array
     */
    protected $config;

    /**
     * InsightApiTest constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->config = require dirname(__DIR__, 2) . '/config/insights.php';
    }

    /** @test */
    public function test_sending_api_call()
    {
        $mock = $this->mock(Client::class);
        $mock->shouldReceive('post')
            ->andReturn(new Response(
                $status = 200,
                $headers = [],
                'ok'
            ));


        $api = $this->app->makeWith(InsightApi::class, [
            'config' => $this->config
        ]);

        $this->assertTrue($api->send($this->config['api_url'], []));
    }

    /** @test */
    public function test_sending_api_call_fails_silently()
    {
        $mock = $this->mock(Client::class);
        $mock->shouldReceive('post')
            ->andReturn(new Response(
                $status = 422,
                $headers = [],
                'ok'
            ));


        $api = $this->app->makeWith(InsightApi::class, [
            'config' => $this->config
        ]);

        $this->assertFalse($api->send($this->config['api_url'], []));
    }
}
