<?php

namespace Mtc\Insights\Providers;

use GuzzleHttp\Client;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;
use Mtc\Insights\Console\Commands\ReportInsightCommand;
use Mtc\Insights\Contracts\InsightMapInterface;
use Mtc\Insights\InsightApi;
use Mtc\Insights\InsightService;
use Mtc\Insights\SmartSchedule;

/**
 * Class InsightProvider
 *
 * @package Mtc\Insights\Providers
 */
class InsightProvider extends ServiceProvider
{
    /**
     * Register the service
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/insights.php', 'insights');

        $this->app->bind(InsightMapInterface::class, config('insights.map_class'));

        $this->app->bind(InsightApi::class, function () {
            return new InsightApi(new Client, config('insights', []));
        });

        $this->app->bind(InsightService::class, function () {
            return new InsightService($this->app->make(InsightMapInterface::class), $this->app->make(InsightApi::class));
        });
    }

    /**
     * Boot the service
     */
    public function boot()
    {
        if ($this->app->runningInConsole() && $this->shouldRun()) {
            $this->commands([
                ReportInsightCommand::class
            ]);

            $this->app->booted(function () {
                $schedule = $this->app->make(Schedule::class);
                $scheduler = $this->app->make(SmartSchedule::class)->loadSchedule();
                $schedule->command('insights:report')->weeklyOn($scheduler->weekday, $scheduler->time);
            });
        }
    }

    /**
     * Check if the reporter should run in current environment
     *
     * @return bool
     */
    protected function shouldRun()
    {
        return in_array(config('app.env'), ['demo', 'production']);
    }

}