<?php

namespace Mtc\Insights\Tests\Unit;

use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Response;
use Mtc\Insights\Contracts\InsightMapInterface;
use Mtc\Insights\InsightApi;
use Mtc\Insights\InsightService;
use Mtc\Insights\PlatformMap;
use Orchestra\Testbench\TestCase as OrchestraTestbench;

/**
 * Class CurrencyTest
 *
 * @package Mtc\Insights\Tests\Unit
 */
class InsightServiceTest extends OrchestraTestbench
{
    /** @test */
    public function test_running_insight_service()
    {
        $mock = $this->mock(Client::class);
        $mock->shouldReceive('post')
            ->andReturn(new Response(
                $status = 200,
                $headers = [],
                'ok'
            ));

        $this->app->bind(InsightMapInterface::class, PlatformMap::class);
        $this->app->bind(InsightApi::class, function () {
            $config = require dirname(__DIR__, 2) . '/config/insights.php';
            return new InsightApi($this->app->make(Client::class) , $config);
        });

        /** @var InsightService $service */
        $service = $this->app->make(InsightService::class);

        $this->assertTrue($service->run());
    }
}
