<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Fallback git binary
    |--------------------------------------------------------------------------
    |
    | In case app isn't able to detect git binary automatically this value will
    | be used as path to git binary
    |
    */

    'fallback_git_binary' => env('GIT_BINARY', '/usr/local/cpanel/3rdparty/lib/path-bin/git'),

    /*
    |--------------------------------------------------------------------------
    | Root level modules
    |--------------------------------------------------------------------------
    |
    | Features that are allowed to be installed as root level modules (legacy)
    |
    */

    'root_modules' => [
        'core' => 'core',
        'cms' => 'core-cms',
        'shop' => 'core-shop',
        'abs' => 'core-accomodationbookingsystem',
    ],

    /*
    |--------------------------------------------------------------------------
    | Autoload injection
    |--------------------------------------------------------------------------
    |
    | Core does require some auto-loading to be injected.
    | This config defines which files/folders should be autoloaded.
    |
    */

    'injected_autoload' => [
        "files" => [
            "core/src/helpers.php"
        ],
        "classmap" => [
            "core/classes",
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Component API
    |--------------------------------------------------------------------------
    |
    | Project System API gives us lists of features available
    |
    */

    'projects_api' => [
        'endpoint' => 'https://projects.mtcmedia.co.uk/api/bitbucket/get_components',
        'api_key' => 'X9Z0AZAHFR',
    ],

];
