<?php

namespace Mtc\Installer\Providers;

use GitWrapper\GitException;
use Mtc\Installer\Console\Commands\CreateEnv;
use Mtc\Installer\Console\Commands\InstallSite;
use GitWrapper\GitWrapper;
use Illuminate\Support\ServiceProvider;
use Mtc\Installer\Console\Commands\InstallLegacyRootModule;
use Mtc\Installer\Installer;

/**
 * Class InstallerServiceProvider
 *
 * @package Mtc\Installer
 */
class InstallerServiceProvider extends ServiceProvider
{
    /**
     * Register service bindings
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/installer.php', 'installer');

        $this->app->singleton('installer', function ($app) {
            try {
                return new Installer(new GitWrapper);
            } catch (GitException $exception) {
                return new Installer(new GitWrapper(config('installer.fallback_git_binary')));
            }
        });
    }

    /**
     * Start (boot) this service
     */
    public function boot()
    {
        $this->commands([
            InstallLegacyRootModule::class,
            InstallSite::class,
            CreateEnv::class,
        ]);
    }
}
