<?php

namespace Mtc\Installer\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Installer\ComponentInstaller;

/**
 * Class InstallSite
 *
 * @package App\Console\Commands
 */
class InstallComponents extends Command
{
    /**
     * @var ComponentInstaller
     */
    protected $installer;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:components';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run the installation for components that have not been installed yet';

    public function __construct(ComponentInstaller $installer)
    {
        parent::__construct();
        $this->installer = $installer;
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        // Skip if site not set up yet
        if (empty(config('database.connections.mysql.database'))) {
            return;
        }

        $this->installer->run($this);
    }
}
