<?php

namespace Mtc\Klarna\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Klarna\Providers\KlarnaServiceProvider;

/**
 * Class InstallKlarna
 * @package Mtc\Klarna\Console\Commands
 */
class InstallKlarna extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:klarna';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Klarna Payment Gateway assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Klarna');

        $this->callSilent('vendor:publish', [
            '--provider' => KlarnaServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->info('Klarna installed successfully.');
    }
}