# Klarna Payments

This package provides payment processing through Klarna (Klarna Payments).
This package is intended to be used with mtcmedia/checkout

Klarna Documentation: https://developers.klarna.com/documentation/klarna-payments/

Klarna API Reference: https://developers.klarna.com/api/

## Installation
Make sure you are installing this on a project that has `composer.mtcassets.com` added as a resource 
```bash
composer require mtcmedia/klarna-payments
```
After composer has installed run the following command that will publish
`klarna.js` and `klarna_payment.vue` to `/resources/js/vendor/app/` 
```bash
php artisan install:klarna
```
Lastly recompile assets to ensure stripe payment component is registered
```bash
npm run dev
```

## Setup

On staging/production server you need to add following keys to `.env` file. 
```
KLARNA_USERNAME=
KLARNA_PASSWORD=
``` 

On production server you need to add following key to `.env` file. 
```
KLARNA_ENVIRONMENT='live'
``` 

*API Credentials are used from:

 - Testing: https://playground.eu.portal.klarna.com/
 
 - Production: https://eu.portal.klarna.com/


## Invoice (Order) capture

By default all Klarna payments will be captured automatically. To disable automatic payment capture change config ``klarna.auto_capture`` to **false**.

To capture Klarna payments manually through admin invoice page, be sure that config ``checkout.deferred_payments`` is set as **true**

## Changelog
See [Changelog](CHANGELOG.md)

## Contributing
Please see [Contributing](CONTRIBUTING.md) for details.