<?php

namespace Mtc\Klarna\Contracts;

use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

/**
 * Interface KlarnaRepositoryContract
 * @package Mtc\Klarna\Contracts
 */
interface KlarnaRepositoryContract
{
    /**
     * Get Invoice data
     *
     * @return array
     */
    public function getInvoiceData(): array;

    /**
     * Get invoice capture data
     *
     * @return array
     */
    public function getInvoiceCaptureData(): array;

    /**
     * KlarnaRepository constructor.
     * @param InvoiceRepositoryContract $invoice_repository
     */
    public function __construct(InvoiceRepositoryContract $invoice_repository);

    /**
     * Get Klarna information for payment form
     *
     * @return array
     */
    public function getInformation(): array;

    /**
     * Place order
     *
     * @param $authorization_token
     * @return bool|mixed|null
     */
    public function placeOrder($authorization_token);

    /**
     * Capture order
     *
     * @param $order_id
     * @return array
     */
    public function captureOrder($order_id);
}