<?php

namespace Mtc\Klarna;

use Illuminate\Support\Facades\App;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Contracts\PayableContract;
use Mtc\Klarna\Contracts\KlarnaRepositoryContract;

/**
 * Class KlarnaApplicableCheck
 * @package Mtc\Klarna
 */
class KlarnaApplicableCheck
{
    /**
     * Check if payment is applicable
     *
     * @param InvoiceRepositoryContract $invoice
     * @param PayableContract $payable
     * @return bool
     */
    public function handle(InvoiceRepositoryContract $invoice, $payable): bool
    {
        $klarna_information = App::make(KlarnaRepositoryContract::class, [
            'invoice_repository' => $invoice
        ])->getInformation();

        return !(empty($klarna_information) || $klarna_information['payment_method_categories']->count() === 0);
    }
}