<?php
return [
    /*
    |--------------------------------------------------------------------------
    | Klarna payments
    |--------------------------------------------------------------------------
    |
    | Enabled/disabled package
    |
    */

    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Klarna credentials
    |--------------------------------------------------------------------------
    |
    | Klarna username
    | Klarna password
    |
    */

    'credentials' => [
        'username' => env('KLARNA_USERNAME', false),
        'password' => env('KLARNA_PASSWORD', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | Klarna environment
    |--------------------------------------------------------------------------
    |
    | Define which Klarna api environment need to use
    |
    | Supported: "live", "testing"
    */

    'environment' => env('KLARNA_ENVIRONMENT', 'testing'),

    /*
    |--------------------------------------------------------------------------
    | Klarna based in
    |--------------------------------------------------------------------------
    |
    | Define which Klarna api endpoint need to use
    |
    | Supported: "EU", "US"
    */

    'based_in' => env('KLARNA_BASED_IN', 'EU'),

    /*
    |--------------------------------------------------------------------------
    | Klarna auto capture
    |--------------------------------------------------------------------------
    |
    | Define if payment should be captured automatically
    |
    */

    'auto_capture' => true,
    
    /*
    |--------------------------------------------------------------------------
    | Payment gateway verifier
    |--------------------------------------------------------------------------
    |
    | Class that allows you to set whether this order can be paid with this payment gateway
    |
    */

    'applicable_check_class' => \Mtc\Klarna\KlarnaApplicableCheck::class,


    /*
    |--------------------------------------------------------------------------
    | Class bindings
    |--------------------------------------------------------------------------
    |
    | These settings define classes that will be used by the application
    |
    */

    'repository_class' => \Mtc\Klarna\Repositories\KlarnaRepository::class,

];