<?php

namespace MTC\WPApiConnector;

use MTC\WPApiConnector\Resources\Categories;
use MTC\WPApiConnector\Resources\Comments;
use MTC\WPApiConnector\Resources\Media;
use MTC\WPApiConnector\Resources\Pages;
use MTC\WPApiConnector\Resources\Plugins;
use MTC\WPApiConnector\Resources\Posts;
use MTC\WPApiConnector\Resources\Tags;
use MTC\WPApiConnector\Resources\Users;

/**
 * @method Comments comments()
 * @method Categories categories()
 * @method Tags tags()
 * @method Media media()
 * @method Pages pages()
 * @method Posts posts()
 * @method Users users()
 * @method Plugins plugins()
 */
class WPApiConnector extends BaseWPApiConnector
{
    protected array $resources = [
        'categories' => Categories::class,
        'tags' => Tags::class,
        'comments' => Comments::class,
        'media' => Media::class,
        'pages' => Pages::class,
        'posts' => Posts::class,
        'users' => Users::class,
        'plugins' => Plugins::class,
    ];
}
