function infoBoxes() {

    "use strict";

    if ($('.infoBoxes > div').length > 1 && $(window).width() < window.breakpoints.mobile && !$('.infoBoxes').hasClass('slick-slider')) {

        $('.infoBoxes').slick({
            dots : false,
            infinite : true,
            arrows : false,
            autoplay : true,
            slidesToShow: 1,
            fade: true,
            cssEase: 'linear'
        });

    } else if ($(window).width() > window.breakpoints.mobile && $('.infoBoxes').hasClass('slick-slider')) {
        $('.infoBoxes').slick('unslick');
    }
}

$(document).ready(function () {

    "use strict";

    // Featured Items
    if ($('.featuredItems .itemsFeatured').length) {
        $('.featuredItems .itemsFeatured').slick({
            dots : false,
            infinite : true,
            arrows : false,
            autoplay : false,
            slidesToShow: 4,
            slidesToScroll: 1,
            responsive: [{
                breakpoint: window.breakpoints.tablet,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1
                }
            }, {
                breakpoint: window.breakpoints.mobile,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1
                }
            }]
        });
    }

    // Brand Scroller
    if ($('.brandScroll').length) {
        $('.brandScroll').slick({
            dots : false,
            infinite : true,
            arrows : false,
            autoplay : false,
            slidesToShow: 6,
            slidesToScroll: 1,
            responsive: [{
                breakpoint: window.breakpoints.tablet,
                settings: {
                    slidesToShow: 4,
                    slidesToScroll: 1
                }
            }, {
                breakpoint: window.breakpoints.mobile,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1
                }
            }]
        });
    }

    // if infoboxes exist
    if ($('.infoBoxes').length) {
        infoBoxes();
    }

}); // document ready

$(window).on('resize', debouncer(function (e) {

/*
 * Force strict mode
 */

    "use strict";

    // if infoboxes exist
    if ($('.infoBoxes').length) {
        infoBoxes();
    }

})); // window resize
