<?php

namespace Mtc\LayoutBrowser\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

/**
 * Class LayoutBrowserProvider
 *
 * @package Mtc\LayoutBrowser\Providers
 */
class LayoutBrowserProvider extends ServiceProvider
{
    /**
     * Boot the service
     */
    public function boot()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');

        if ($this->app->runningInConsole() === false) {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }
    }
}
