/**
 * Slideshow
 */

function loadifySlider() {
    'use strict';

    if ($('.sliderWrap ul li').length > 1) {

        $('.slider')
            .on('init', function(event, slick) {
                $('.sliderWrap .skipVisibilityCheck').removeClass('skipVisibilityCheck');
            })
    }
}
$(document).ready(function () {
    'use strict';

    loadifySlider();

    if ($('.opacityWrap ul li').length > 1) {
        $('.opacityItems').slick({
            dots: false,
            infinite: true,
            arrows: true,
            autoplay: false,
            slidesToShow: 4,
            slidesToScroll: 1,
            appendArrows: '.opacityWrap .itemDisplayTitle span',
            responsive: [{
                breakpoint: (window.breakpoints.tablet + 20),
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 3
                }
            }, {
                breakpoint: (window.breakpoints.mobile + 1),
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 2,
                    arrows: false
                }
            }]
        });
    }

    if ($('.sliderFadeWrap ul li').length > 1) {

        var autoplaySpeed = 4000,
            speed = (matchesMediaQuery('mobile', 0)) ? 1200 : 1000;

        $('.sliderFadeItems').slick({
            dots: true,
            infinite: true,
            arrows: true,
            fade: true,
            autoplay: false,
            autoplaySpeed: autoplaySpeed,
            speed: speed,
            touchThreshold: 65,
            touchMove: true,
            cssEase: 'ease-in-out',
            responsive: [
                {
                    breakpoint: window.breakpoints.mobile,
                    settings: {
                        arrows: false,
                        speed: speed
                    }
                }
            ]
        });
    }
});

$(window).on('resize', debouncer(function (e) {
    'use strict';

    loadifySlider();

})); // debounce

