
function initMobileFilter() {

    'use strict';

    var filter = $('#productFilter');

    if (filter.is(':hidden')) {
        filter.show();
        filter.data('height', filter.height());
        filter.hide();
    } else {
        filter.data('height', filter.height());
    }

}

function fixTallFilter() {

    'use strict';

    var siteWrapper = $('.siteWrapper'),
        filter  = $('#productFilter'),
        filterHeight;

    if (filter.length > 0) {
        siteWrapper.css({
            height: 'auto'
        });

        filterHeight = filter.height() + filter.offset().top;

        if (filterHeight > siteWrapper.height() && filter.is(':visible')) {
            siteWrapper.height(filterHeight);
        }
    }
}

function filterScrollbar() {

    'use strict';

    var sections = $('.overflowWrap'),
        filterWrap = $('.productFilterSelectionWrap');

    if (sections.length > 0) {
        if ($(window).width() <= window.breakpoints.mobile) {
            if (filterWrap.hasClass('hasScrollbars')) {
                filterWrap.removeClass('hasScrollbars');
                sections.perfectScrollbar('destroy');
            }
        } else {
            if (!$('.productFilterSelectionWrap').hasClass('hasScrollbars')) {
                filterWrap.addClass('hasScrollbars');
                sections.perfectScrollbar();
            }
        }
    }
}

$(document).ready(function () {

    'use strict';

    if ($('#productFilter').length > 0) {
        initMobileFilter();
    }

    $('.productFilterButtonMobile').on('click', function (e) {
        var filterContainer = $('#productFilter'),
            cachedThis = $(this),
            thisPosition = cachedThis.outerHeight();

        e.preventDefault();

        if (filterContainer.is(':hidden')) {

            filterContainer.fadeIn(function () {
                fixTallFilter();
            });
            cachedThis.addClass('open');
            cachedThis.data('text', cachedThis.text());
            cachedThis.text('Done');
            filterContainer.css({
                top: thisPosition
            });

        } else {
            filterContainer.fadeOut(function () {
                fixTallFilter();
            });
            cachedThis.removeClass('open');
            cachedThis.text(cachedThis.data('text'));

        }
    });

    $('.productFilterButtonDesktop').on('click', function (e) {
        var filterContainer = $('#productFilter'),
            cachedThis = $(this);

        e.preventDefault();

        if (filterContainer.is(':hidden')) {
            filterContainer.css({
                top: 0
            });
            filterContainer.fadeIn();
            cachedThis.addClass('open');
            cachedThis.data('text', cachedThis.text());
            cachedThis.text('Done');
            $('.overflowWrap.ps-container').perfectScrollbar('update');

        } else {
            filterContainer.fadeOut();
            cachedThis.removeClass('open');
            cachedThis.text(cachedThis.data('text'));

        }
    });

    //replace the default filter section collapse
    if ($('#productFilter').length) {

        $('.collapseMe').each(function () {

            var filterSortContainer = $(this).next(),
                cachedThis = $(this);

            cachedThis.find('i').removeClass().addClass('fa fa-angle-down');

            if (filterSortContainer.css('display') !== 'none') {
                cachedThis.addClass('open');
            }

        });

        $('body').off('click', '.collapseMe');

        $('body').on('click', '.collapseMe', function () {
            if ($(window).width() <= window.breakpoints.mobile) {
                var filterSortContainer = $(this).next(),
                    cachedThis = $(this);

                if (filterSortContainer.is(':hidden')) {
                    filterSortContainer.slideDown(function () {
                        fixTallFilter();
                    });
                    cachedThis.addClass('open');
                } else {
                    filterSortContainer.slideUp(function () {
                        fixTallFilter();
                    });
                    cachedThis.removeClass('open');
                }
            }
        });

    }

    filterScrollbar();


}); // document ready

$(window).on('resize', debouncer(function (e) {

/*
 * Force strict mode
 */

    'use strict';

    fixTallFilter();

    filterScrollbar();


})); // debounce
