function subNavActive() {

    "use strict";

    // if window width is mobile size
    if ($(window).width() <= window.breakpoints.mobile) {
        $('.js_contentSidebar').addClass('activeSlideNav');
    } else {
        $('.js_contentSidebar').removeClass('activeSlideNav');
        $('.js_contentSidebar ul').css({
            display: ''
        });
    }

}

function infoBoxes() {
    if ($('.infoBoxes > div').length > 1 && $(window).width() < window.breakpoints.mobile && !$('.infoBoxes').hasClass('slick-slider')) {

        $('.infoBoxes').slick({
            dots : false,
            infinite : true,
            arrows : false,
            autoplay : true,
            slidesToShow: 1,
            fade: true,
            cssEase: 'linear'
        });

    } else if ($(window).width() > window.breakpoints.mobile && $('.infoBoxes').hasClass('slick-slider')) {
        $('.infoBoxes').slick('unslick');
    }
}

function slideShow() {
    'use strict';

    if ($('.sliderWrap ul li').length > 1) {

        var speed = 4000;

        $('.slider').slick({
            dots : true,
            infinite : true,
            arrows : true,
            autoplay : true,
            autoplaySpeed : speed,
            prevArrow: '<i class="fa fa-angle-left slideshowLeftArrow"></i>',
            nextArrow: '<i class="fa fa-angle-right slideshowRightArrow"></i>',
            speed: 1200,
            customPaging: function(slick, index) {
                return '<a>' + index + '</a>';
            }
        });
    }
}

$(document).ready(function () {

    "use strict";

    // if sidebar exists
    if ($('.js_contentSidebar').length) {
        subNavActive();
    }

    // on click of sidebar h3
    $('.js_contentSidebar h3').on('click', function () {
        if ($(this).parent('.js_contentSidebar').hasClass('activeSlideNav')) {
            $(this).next().slideFadeToggle();
        }
    });

    // Featured Items
    if ($('.featuredItems .itemsFeatured').length) {
        $('.featuredItems .itemsFeatured').slick({
            dots : false,
            infinite : true,
            arrows : false,
            autoplay : false,
            slidesToShow: 4,
            slidesToScroll: 1,
            responsive: [{
                breakpoint: window.breakpoints.tablet,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1
                }
            }, {
                breakpoint: window.breakpoints.mobile,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1
                }
            }]
        });
    }

    // Brand Scroller
    if ($('.brandScroll').length) {
        $('.brandScroll').slick({
            dots : false,
            infinite : true,
            arrows : false,
            autoplay : false,
            slidesToShow: 6,
            slidesToScroll: 1,
            responsive: [{
                breakpoint: window.breakpoints.tablet,
                settings: {
                    slidesToShow: 4,
                    slidesToScroll: 1
                }
            }, {
                breakpoint: window.breakpoints.mobile,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1
                }
            }]
        });
    }

    // if infoboxes exist
    if ($('.infoBoxes').length) {
        infoBoxes();
    }

    slideShow();

}); // document ready

$(window).on('resize', debouncer(function (e) {

/* ------------------------------ */
/* Force strict mode */
/* ------------------------------ */

    "use strict";

    // if sidebar exists
    if ($('.js_contentSidebar').length) {
        subNavActive();
    }

    // if infoboxes exist
    if ($('.infoBoxes').length) {
        infoBoxes();
    }

})); // window resize
