$(document).ready(function () {

/*
 * Force strict mode
 */

    'use strict';

/*
 * Item Back Button
 */

    $('.itemBackButton').on('click', function (e) {
        e.preventDefault();
        window.history.back();
    });

/*
 * MTC Zoom
 * Provides gallery and zoom functions on item page
 */

    if ($('.enableZoom').length) {
        $('.enableZoom').mtcZoom({
            hideMessageOnLaunch: true
        });
    }

/*
 * Colour Linked Items Change
 */

    if ($('#colourLinkedItems').length) {

        $('body').on('change', '#colourLinkedItems', function () {
            var link = $(this).find(':selected').data('link');

            if (link !== undefined) {
                window.location.href = link;
            }
        });

    }

/*
 * Description Accordion
 */

    if ($('.accordionWrapper').length) {

        // hide all accordion content
        $('.accordionContent').hide().removeClass('accordionContentOpen');

        // show open accordion content
        $('.accordionOpen .accordionContent').show().addClass('accordionContentOpen');

        $('.accordionHeading').on('click', function () {
            var $this = $(this);

            $('.accordionContentWrap').removeClass('accordionOpen');

            // remove class form all other
            $('.accordionHeading').removeClass('accordionHeadingOpen');

            // slide up any open accordion
            $this.parents('.accordionWrapper').children().find('.accordionContent').slideUp();

            // if this is hidden slide it down
            if ($this.next().is(':hidden')) {

                // add class to this
                $this.addClass('accordionHeadingOpen');

                // add class to this
                $this.next().slideDown(function () {
                    $this.parent('.accordionContentWrap').addClass('accordionOpen');
                });

            }

        }); // .on 'click' end

    } // if length end

}); // document ready

$(window).on('resize', debouncer(function (e) {

/*
 * Force strict mode
 */

    'use strict';

})); // debounce
