<?php


    namespace Mtc\AutoInvoice\Cron;

    use Psr\Log\LoggerInterface;
    use Mtc\AutoInvoice\Api\InvoiceProcessInterface;
    use Mtc\AutoInvoice\Helper\Data as HelperData;

class InvoiceProcess
{

    /**
     * @param HelperData              $helperData
     * @param LoggerInterface         $logger
     * @param InvoiceProcessInterface $invoiceProcess
     */
    public function __construct(
        private HelperData $helperData,
        private LoggerInterface $logger,
        private InvoiceProcessInterface $invoiceProcess
    ) {
    }

    /**
     * Process completed orders with no invoice, if cron is enabled
     */
    public function execute()
    {

        if (!$this->helperData->isCronEnabled()) {
            return;
        }

        $this->logger->info('Starting auto invoice procedure.');
        $items = $this->invoiceProcess->getItemsToProcess();

        foreach ($items as $item) {
            try {
                $order = $item->getOrder();
                $this->logger->info(
                    sprintf(
                        'Invoicing order #%s',
                        $order->getIncrementId()
                    )
                );
                $this->invoiceProcess->invoice($item);
            } catch (\Exception $ex) {
                $this->logger->critical($ex->getMessage());
            }
        }

        $this->logger->info('Auto invoice procedure completed.');
    }
}
