<?php

namespace Mtc\AutoInvoice\Plugin\Order;


use Mtc\AutoInvoice\Api\InvoiceProcessInterface;
use Mtc\AutoInvoice\Helper\Data as HelperData;
use Psr\Log\LoggerInterface;

class PlaceAfterPlugin
{
    public function __construct(
        private HelperData $helperData,
        private LoggerInterface $logger,
        private InvoiceProcessInterface $invoiceProcess
    ) {
    }

    /**
     * @param \Magento\Sales\Api\OrderManagementInterface $orderManagementInterface
     * @param \Magento\Sales\Model\Order\Interceptor $order
     * @return $order
     */
    public function afterPlace(\Magento\Sales\Api\OrderManagementInterface $orderManagementInterface , $order)
    {
        $orderId = $order->getId();
        $rules = $this->helperData->getProcessingRules();
        $orderPaymentMethod = $order->getPayment()->getMethod();
        $findMethod = array_keys(array_combine(array_keys($rules), array_column($rules, HelperData::RULE_PAYMENT_METHOD)), $orderPaymentMethod);
        $items  = $this->invoiceProcess->getItemsToProcess($order->getIncrementId());

        foreach ($items as $orderProccess) {
            if ($findMethod && count($findMethod) > 0) {
                try {
                    $this->logger->info(
                        sprintf(
                            'Mtc AutoInvoice Plugin - Invoicing order #%s',
                            $orderProccess->getIncrementId()
                        )
                    );
                    $this->invoiceProcess->invoice($orderProccess);
                } catch (\Exception $ex) {
                    $this->logger->error($ex->getMessage());
                }
                $this->logger->info('Auto invoice procedure completed.');
            }
        }
        return $order;
    }


}
