<?php
/**
 * Client for BugSnag
 * Extending from bugsnag-php (https://github.com/bugsnag/bugsnag-php)
 *
 * @author Josh Carter <josh@interjar.com>
 */
namespace Interjar\BugSnag\Bugsnag;

use Bugsnag\Client as BugSnag_Client;
use Interjar\BugSnag\Helper\Config;

class Client extends BugSnag_Client
{

    /**
     * Client constructor
     * Get API KEY from env.php and create instance of BugSnag_Client
     *
     * @param Config $config
     */
    public function __construct(
        protected Config $config
    )
    {
        $this->config = $config->getConfiguration();
        if($this->config) {
            parent::__construct($this->config, null, parent::makeGuzzle());
        }
    }

}
