<?php

namespace Mtc\BypassImageCache\Plugin\Model\Product;

use Magento\Catalog\Model\Product\Image;
use Mtc\BypassImageCache\Model\IsAllowed;

class ImagePlugin
{
    /**
     * @var IsAllowed
     */
    protected $isAllowed;

    public function __construct(IsAllowed $isAllowed)
    {
        $this->isAllowed = $isAllowed;
    }

    public function afterIsCached(Image $subject, $result)
    {
        if (!$result && $this->isAllowed->execute($subject->getBaseFile(), $subject->getDestinationSubdir())) {
            return true;
        }
        return $result;
    }

}
