<?php

namespace Mtc\CatalogHoverImage\Block\Adminhtml\System\Config\Fieldset;

use Magento\Backend\Block\Template;
use Magento\Framework\Data\Form\Element\Renderer\RendererInterface;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Module\ModuleList\Loader;
use Mtc\CatalogHoverImage\Helper\Config as Helper;

class Hint extends Template implements RendererInterface
{
    /**
     * @var string
     */
    protected $_template = 'Mtc_CatalogHoverImage::system/config/fieldset/hint.phtml';

    /**
     * @var \Magento\Framework\Module\ModuleList\Loader
     */
    private $loader;

    /**
     * @var \Mtc\CatalogHoverImage\Helper\Config
     */
    private $helper;

    /**
     * Hint constructor.
     *
     * @param Context $context
     * @param Loader  $loader
     * @param Helper  $helper
     * @param array   $data
     */
    public function __construct(
        Context $context,
        Loader $loader,
        Helper $helper,
        array $data = []
    ) {
        $this->loader = $loader;
        $this->helper = $helper;
        parent::__construct($context, $data);
    }

    /**
     * @param  \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return mixed
     */
    public function render(AbstractElement $element)
    {
        return $this->toHtml();
    }

    /**
     * @return mixed
     */
    public function getModuleName()
    {
        return $this->helper->getConfigModule('module_name');
    }

    /**
     * @return string
     */
    public function getVersion()
    {
        $modules = $this->loader->load();
        $v = "";
        if (isset($modules['Mtc_CatalogHoverImage'])) {
            $v = "v" . $modules['Mtc_CatalogHoverImage']['setup_version'];
        }

        return $v;
    }
}
