<?php
namespace Mtc\Clans\Model;

use Mtc\Clans\Api\Data\SurnameManagerSearchResultsInterface;
use Mtc\Clans\Api\SurnameManagerRepositoryInterface;
use Mtc\Clans\Model\SurnameManager as SurnameManagerAlias;
use Mtc\Clans\Model\ResourceModel\SurnameManager as ResourceSurnameManager;
use Mtc\Clans\Model\ResourceModel\SurnameManager\CollectionFactory as SurnameManagerCollectionFactory;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Mtc\Clans\Api\Data\SurnameManagerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Mtc\Clans\Model\ResourceModel\SurnameManager\Collection;
use Mtc\Clans\Api\Data\SurnameManagerSearchResultsInterfaceFactory;
use Psr\Log\LoggerInterface;

/**
 * This is SurnamenManagerRepository class
 * Class SurnameManagerRepository
 */
class SurnameManagerRepository implements SurnameManagerRepositoryInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var ResourceSurnameManager
     */
    private $resourceEventManager;

    /**
     * @var SurnameManagerFactory
     */
    private $eventManagerFactory;

    /**
     * @var SurnameManagerCollectionFactory
     */
    private $eventManagerCollectionFactory;

    /**
     * @var SurnameManagerInterface
     */
    private $dataEventManager;

    /**
     * @var CollectionProcessorInterface
     */
    private $collectionProcessor;

    /**
     * @var SurnameManagerSearchResultsInterfaceFactory
     */
    private $searchResultsFactory;

    /**
     * @param ResourceSurnameManager $resourceEventManager
     * @param SurnameManagerFactory $eventManagerFactory
     * @param SurnameManagerCollectionFactory $eventManagerCollectionFactory
     * @param SurnameManagerSearchResultsInterfaceFactory $searchResultsFactory
     * @param CollectionProcessorInterface|null $collectionProcessor
     * @param LoggerInterface $logger
     */
    public function __construct(
        ResourceSurnameManager $resourceEventManager,
        SurnameManagerFactory $eventManagerFactory,
        SurnameManagerCollectionFactory $eventManagerCollectionFactory,
        SurnameManagerSearchResultsInterfaceFactory $searchResultsFactory,
        CollectionProcessorInterface $collectionProcessor = null,
        LoggerInterface $logger
    ) {
        $this->resourceEventManager = $resourceEventManager;
        $this->eventManagerFactory = $eventManagerFactory;
        $this->eventManagerCollectionFactory = $eventManagerCollectionFactory;
        $this->collectionProcessor = $collectionProcessor;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->logger = $logger;
    }

    /**
     * Save Block data
     * @param SurnameManagerInterface $eventManager
     * @return SurnameManagerInterface
     * @throws CouldNotSaveException
     */
    public function save(SurnameManagerInterface $eventManager)
    {
        try {
            $this->resourceEventManager->save($eventManager);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__($exception->getMessage()));
        }
        return $eventManager;
    }

    /**
     * @param $surnameId
     * @return null
     */
    public function getEntityIdBySurnameId($surnameId)
    {
        $customer = $this->eventManagerCollectionFactory->create();
        $dataUser = $customer->addFieldToFilter('surname_id', $surnameId)
            ->getFirstItem();
        if ($dataUser && $dataUser->getId()) {
            return $dataUser->getEntityId();
        } else {
            return null;
        }
    }

    /**
     * Load Block data by given Block Identity
     *
     * @param $eventManagerId
     * @return SurnameManagerAlias
     */
    public function getById($eventManagerId)
    {
        /**
         * @var SurnameManager $eventManager
         */
        $eventManager = $this->eventManagerFactory->create();
        $this->resourceEventManager->load($eventManager, $eventManagerId);
        return $eventManager;
    }

    /**
     * Load Page data collection by given search criteria
     *
     * @param SearchCriteriaInterface $criteria
     * @return SurnameManagerSearchResultsInterface
     */

    public function getList(SearchCriteriaInterface $criteria)
    {
        /** @var Collection $collection */
        $collection = $this->eventManagerCollectionFactory->create();

        foreach ($criteria->getFilterGroups() as $filterGroup) {
            foreach ($filterGroup->getFilters() as $filter) {
                $condition = $filter->getConditionType() ?: 'eq';
                $collection->addFieldToFilter($filter->getField(), [$condition => $filter->getValue()]);
            }
        }

        $this->collectionProcessor->process($criteria, $collection);

        /** @var SurnameManagerSearchResultsInterface $searchResults */
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        $searchResults->setItems($collection->getItems());
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * Delete Block
     *
     * @param SurnameManagerInterface $eventManager
     * @return bool
     * @throws CouldNotDeleteException
     */
    public function delete(SurnameManagerInterface $eventManager)
    {
        try {
            $this->resourceEventManager->delete($eventManager);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__($exception->getMessage()));
        }
        return true;
    }

    /**
     * Delete SurnameManager by given Block Identity
     *
     * @param string $eventManagerId
     * @return bool|mixed
     */
    public function deleteById($eventManagerId)
    {
        try {
            return $this->delete($this->getById($eventManagerId));
        } catch (\Exception $exception) {
            $this->logger->debug($exception->getMessage());
        }
    }
}
