<?php
namespace Mtc\Clans\Block\Adminhtml\Edit;

use Magento\Backend\Block\Widget\Context;
use Mtc\Clans\Api\SurnameManagerRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Generic class for all buttons
 *
 * Class GenericButton
 */
class GenericButton
{
    /**
     * @var Context
     */
    private $context;

    /**
     * @var SurnameManagerRepositoryInterface
     */
    private $eventManagerRepository;

    /**
     * @param Context $context
     * @param SurnameManagerRepositoryInterface $eventManagerRepository
     */
    public function __construct(
        Context $context,
        SurnameManagerRepositoryInterface $eventManagerRepository
    ) {
        $this->context = $context;
        $this->eventManagerRepository = $eventManagerRepository;
    }

    /**
     * Return Surname Id
     *
     * @return int|null
     */
    public function getId()
    {
        try {
            if (empty($this->context->getRequest()->getParam('entity_id'))) {
                return null;
            }
            return $this->eventManagerRepository->getById(
                $this->context->getRequest()->getParam('entity_id')
            )->getEntityId();
        } catch (NoSuchEntityException $e) {
            $e->getMessage();
        }
        return null;
    }

    /**
     * Generate url by route and parameters
     *
     * @param   string $route
     * @param   array $params
     * @return  string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }
}
