<?php
namespace Mtc\Clans\Controller\Adminhtml\Manage;

use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Mtc\Clans\Api\ClanManagerRepositoryInterface;
use Magento\Backend\App\Action\Context;
use Magento\Backend\App\Action;
use Mtc\Clans\Model\ClanManagerFactory;

/**
 * This Class is used to add new or update existing record
 *
 * Class Edit
 */
class Edit extends Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Mtc_Clans::manage_clan';

    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var ClanManagerRepositoryInterface
     */
    private $eventManagerRepositoryInterface;

    /**
     * Core registry
     *
     * @var Registry
     */
    private $coreRegistry = null;

    /**
     * @var ClanManagerFactory
     */
    private $clanManager;

    /**
     * Edit constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param ClanManagerRepositoryInterface $eventManagerRepositoryInterface
     * @param Registry $registry
     * @param ClanManagerFactory $clanManager
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        ClanManagerRepositoryInterface $eventManagerRepositoryInterface,
        Registry $registry,
        ClanManagerFactory $clanManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->eventManagerRepositoryInterface = $eventManagerRepositoryInterface;
        $this->coreRegistry = $registry;
        $this->clanManager = $clanManager;
        parent::__construct($context);
    }

    /**
     * Edit CMS page
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        // 1. Get ID and create model and breadcrumbs
        $id = $this->getRequest()->getParam('entity_id');
        $model = $id?$this->eventManagerRepositoryInterface->getById($id):$this->clanManager->create();
        $this->coreRegistry->register('clans_data', $model);
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mtc_Clans::clan')
            ->addBreadcrumb(__('Clan'), __('Clan'))
            ->addBreadcrumb(__('Manage Clan'), __('Manage Clan'));
        $resultPage->addBreadcrumb(
            $id ? __('Edit Clan') : __('New Clan'),
            $id ? __('Edit Clan') : __('New Clan')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Clans'));
        $resultPage->getConfig()->getTitle()
            ->prepend($id ? $model->getClan() : __('New Clan'));
        return $resultPage;
    }
}
