<?php
namespace Mtc\Clans\Model;

use Mtc\Clans\Api\Data\SurnameManagerInterface;
use Mtc\Clans\Model\ResourceModel\SurnameManager as SurnameManagerResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractExtensibleModel;

/**
 * This model class is used for the Curd operation of Clans
 *
 * Class SurnameManager
 */
class SurnameManager extends AbstractExtensibleModel implements SurnameManagerInterface, IdentityInterface
{

    /**
     * @var PAGE_CACHE
     */
    const CACHE_TAG = 'mtc_surname_manager';

    /**
     * @var PAGE_CACHE|string
     */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * Constructor to initialize ResourceModel
     */
    public function _construct()
    {
        $this->_init(SurnameManagerResourceModel::class);
    }

    /**
     * Return unique ID(s) for each object in system
     *
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId(), self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @param int $entityId
     * @return $this
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param string $surname
     * @return $this
     */
    public function setSurname($surname)
    {
        return $this->setData(self::SURNAME, $surname);
    }

    /**
     * @return string
     */
    public function getSurname()
    {
        return $this->getData(self::SURNAME);
    }

    /**
     * @param string $surnameId
     * @return $this
     */
    public function setSurnameId($surnameId)
    {
        return $this->setData(self::SURNAME_ID, $surnameId);
    }

    /**
     * @return string
     */
    public function getSurnameId()
    {
        return $this->getData(self::SURNAME_ID);
    }

    /**
     * @param string $noteTxt
     * @return $this
     */
    public function setNoteTxt($noteTxt)
    {
        return $this->setData(self::NOTE_TXT, $noteTxt);
    }

    /**
     * @return string
     */
    public function getNoteTxt()
    {
        return $this->getData(self::NOTE_TXT);
    }

    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT);
    }

    /**
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }
}
