<?php
namespace Mtc\Clans\Api;

use Mtc\Clans\Api\Data\ClanManagerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Declared inter
 * interface ClanManagerRepositoryInterface
 */
interface ClanManagerRepositoryInterface
{
    /**
     * Save clan.
     *
     * @param ClanManagerInterface $event
     * @return mixed
     */
    public function save(ClanManagerInterface $event);

    /**
     * Retrieve clan.
     *
     * @param $clanId
     * @return mixed
     */
    public function getById($clanId);

    /**
     * Retrieve list matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete tartan.
     *
     * @param ClanManagerInterface $clan
     * @return mixed
     */
    public function delete(ClanManagerInterface $clan);

    /**
     * Delete clan by ID.
     *
     * @param $tartanId
     * @return mixed
     */
    public function deleteById($clanId);

    /**
     * @param $clanId
     * @return null
     */
    public function getEntityIdByClanId($clanId);
}
