<?php
namespace Mtc\Clans\Controller\Adminhtml\Manage;

use Mtc\Clans\Model\ClanManager;
use Magento\Backend\Model\View\Result\Redirect as RedirectAlias;
use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\View\Result\PageFactory;
use Magento\Backend\App\Action\Context;
use Mtc\Clans\Api\ClanManagerRepositoryInterface;
use Mtc\Clans\Model\ClanManagerFactory;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Action for save button
 *
 * Class Save
 */
class Save extends AbstractController
{
    /**
     * Constant
     */
    const DATE_FORMAT = 'Y-m-d';

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

    /**
     * @var ClanManagerFactory
     */
    private $eventManagerFactory;

    /**
     * @var ClanManagerRepositoryInterface
     */
    private $eventManagerRepository;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param DataPersistorInterface $dataPersistor
     * @param ClanManagerFactory $eventManagerFactory
     * @param ClanManagerRepositoryInterface $eventManagerRepository
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        DataPersistorInterface $dataPersistor,
        ClanManagerFactory $eventManagerFactory,
        ClanManagerRepositoryInterface $eventManagerRepository
    ) {
        $this->dataPersistor = $dataPersistor;
        $this->eventManagerFactory = $eventManagerFactory;
        $this->eventManagerRepository = $eventManagerRepository;
        parent::__construct($context, $resultPageFactory);
    }

    /**
     * Save action
     *
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        /** @var RedirectAlias $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        $model = $this->eventManagerFactory->create();
        if ($data) {
            $generalData = $data;

            /** @var ClanManager $model */
            if (isset($generalData['entity_id'])) {
                $id = $generalData['entity_id'];
                try {
                    $model = $this->eventManagerRepository->getById($id);
                } catch (LocalizedException $e) {
                    $this->messageManager
                        ->addErrorMessage(__('This clan no longer exists.'));
                    return $this->processResultRedirect($model, $resultRedirect, $data);
                }
            }
            $model->setData($generalData);
            try {
                $model->setUpdatedAt('');
                $this->eventManagerRepository->save($model);
                $this->messageManager->addSuccessMessage(__('You saved the clan.'));
                return $this->processResultRedirect($model, $resultRedirect, $data);
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage(
                    $e,
                    __('Something went wrong while saving the clan.')
                );
            }
            $this->dataPersistor->set('mtc_clan_manager', $data);
            return $this->processResultRedirect($model, $resultRedirect, $data);
        }
        return $this->processResultRedirect($model, $resultRedirect, $data);
    }

    /**
     * Process result redirect
     *
     * @param $model
     * @param $resultRedirect
     * @param $data
     * @return mixed
     */
    private function processResultRedirect($model, $resultRedirect, $data)
    {
        $this->dataPersistor->clear('mtc_clan_manager');
        if ($this->getRequest()->getParam('back', false) === 'continue') {
            return $resultRedirect->setPath('*/*/edit', ['entity_id' => $model->getId(), '_current' => true]);
        }
        if ($this->getRequest()->getParam('back', false) === 'edit') {
            return $resultRedirect->setPath('*/*/edit', ['entity_id' => $model->getId(), '_current' => true]);
        }
        return $resultRedirect->setPath('*/*/index');
    }
}
