<?php
namespace Mtc\Clans\Controller\Adminhtml\Surname;

use Mtc\Clans\Model\SurnameManager;
use Magento\Backend\Model\View\Result\Redirect as RedirectAlias;
use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\View\Result\PageFactory;
use Magento\Backend\App\Action\Context;
use Mtc\Clans\Api\SurnameManagerRepositoryInterface;
use Mtc\Clans\Model\SurnameManagerFactory;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;

/**
 * Action for save button
 *
 * Class Save
 */
class Save extends AbstractController
{
    /**
     * Constant
     */
    const DATE_FORMAT = 'Y-m-d';

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

    /**
     * @var SurnameManagerFactory
     */
    private $eventManagerFactory;

    /**
     * @var SurnameManagerRepositoryInterface
     */
    private $eventManagerRepository;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param DataPersistorInterface $dataPersistor
     * @param SurnameManagerFactory $eventManagerFactory
     * @param SurnameManagerRepositoryInterface $eventManagerRepository
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        DataPersistorInterface $dataPersistor,
        SurnameManagerFactory $eventManagerFactory,
        SurnameManagerRepositoryInterface $eventManagerRepository
    ) {
        $this->dataPersistor = $dataPersistor;
        $this->eventManagerFactory = $eventManagerFactory;
        $this->eventManagerRepository = $eventManagerRepository;
        parent::__construct($context, $resultPageFactory);
    }

    /**
     * Save action
     *
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        /** @var RedirectAlias $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        $model = $this->eventManagerFactory->create();
        if ($data) {
            $generalData = $data;
            $id = $generalData['entity_id'];
            /** @var SurnameManager $model */
            if ($id) {
                try {
                    $model = $this->eventManagerRepository->getById($id);
                } catch (LocalizedException $e) {
                    $this->messageManager
                        ->addErrorMessage(__('This surname no longer exists.'));
                    return $this->processResultRedirect($model, $resultRedirect, $data);
                }
            }
            $model->setData($generalData);
            try {
                $model->setUpdatedAt('');
                $this->eventManagerRepository->save($model);
                $this->messageManager->addSuccessMessage(__('You saved the surname.'));
                return $this->processResultRedirect($model, $resultRedirect, $data);
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage(
                    $e,
                    __('Something went wrong while saving the surname.')
                );
            }
            $this->dataPersistor->set('mtc_surname_manager', $data);
            return $this->processResultRedirect($model, $resultRedirect, $data);
        }
        return $this->processResultRedirect($model, $resultRedirect, $data);
    }

    /**
     * Process result redirect
     *
     * @param $model
     * @param $resultRedirect
     * @param $data
     * @return mixed
     */
    private function processResultRedirect($model, $resultRedirect, $data)
    {
        $this->dataPersistor->clear('mtc_surname_manager');
        if ($this->getRequest()->getParam('back', false) === 'continue') {
            return $resultRedirect->setPath('*/*/edit', ['entity_id' => $model->getId(), '_current' => true]);
        }
        return $resultRedirect->setPath('*/*/index');
    }
}
