<?php
namespace Mtc\Clans\Block\Adminhtml\Clan\Edit\Tab;

use Exception;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Mtc\Clans\Model\ClanManager;
use Mtc\Finder\Model\ResourceModel\TartanManager\CollectionFactory;
use Mtc\Clans\Model\ClanManagerFactory;

class Tartan extends Extended
{

    /**
     * Core registry
     *
     * @var Registry
     */
    private $coreRegistry = null;

    /**
     * @var CollectionFactory
     */
    private $tartanManager;

    private $clanManager;

    /**
     * @param Context $context
     * @param Data $backendHelper
     * @param TartanManagerFactory $tartanManager
     * @param Registry $coreRegistry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $backendHelper,
        CollectionFactory $tartanManager,
        ClanManagerFactory $clanManager,
        Registry $coreRegistry,
        array $data = []
    ) {

        $this->tartanManager = $tartanManager;
        $this->clanManager = $clanManager;
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * @return void
     * @throws FileSystemException
     */
    public function _construct()
    {
        parent::_construct();
        $this->setId('clans_tartan_grid');
        $this->setDefaultSort('tartan_id');
        $this->setUseAjax(true);
        if ($this->isReadonly()) {
            $this->setFilterVisibility(false);
        }
    }

    /**
     * @param $column
     * @return $this|Tartan
     * @throws LocalizedException
     */
    protected function _addColumnFilterToCollection($column)
    {
        if ($column->getId() == 'in_tartans') {
            $blockIds = $this->_getSelectedBlocks();
            if (empty($blockIds)) {
                $blockIds = 0;
            }
            if ($blockIds) {
                if ($column->getFilter()->getValue()) {
                    $tartansIds = [];
                    foreach ($blockIds as $id) {
                        $tartansIds[] = $id['tartan_entity_id'];
                    }
                    $this->getCollection()->addFieldToFilter('entity_id', ['in' => $tartansIds]);
                } else {
                    $tartansIds = [];
                    foreach ($blockIds as $id) {
                        $tartansIds[] = $id['tartan_entity_id'];
                    }
                    if ($tartansIds) {
                        $this->getCollection()->addFieldToFilter('entity_id', ['nin' => $tartansIds]);
                    }
                }
            }

        } else {
            parent::_addColumnFilterToCollection($column);
        }

        return $this;
    }

    /**
     * Prepare collection
     *
     * @return Extended
     */
    protected function _prepareCollection()
    {
        $collection = $this->tartanManager->create();
        if ($this->isReadonly()) {
            $blockIds = $this->_getSelectedBlocks();
            if (empty($blockIds)) {
                $blockIds = [0];
            }

            $collection->addFieldToFilter('tartan_id', ['in' => $blockIds]);
        }

        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    /**
     * @return mixed|null
     */
    protected function _getBlock()
    {
        return $this->coreRegistry->registry('current_clans_tartan');
    }

    /**
     * @return int
     */
    public function isReadonly()
    {
        return 0;
    }

    /**
     * @return Tartan
     * @throws Exception
     */
    protected function _prepareColumns()
    {
        if (!$this->isReadonly()) {
            $this->addColumn(
                'in_tartans',
                [
                    'type' => 'checkbox',
                    'name' => 'in_tartans',
                    'values' => $this->_getSelectedTartans(),
                    'align' => 'center',
                    'index' => 'entity_id',
                    'header_css_class' => 'col-select',
                    'column_css_class' => 'col-select'
                ]
            );
        }

        $this->addColumn(
            'tartan_entity_id',
            [
                'header' => __('ID'),
                'sortable' => true,
                'index' => 'entity_id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );

        $this->addColumn(
            'tartan_id',
            [
                'header' => __('Tartan Id'),
                'sortable' => true,
                'index' => 'tartan_id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );

        $this->addColumn(
            'name',
            [
                'header' => __('Tartan Name'),
                'sortable' => true,
                'index' => 'name',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

        $this->addColumn(
            'partner',
            [
                'header' => __('Partner'),
                'sortable' => true,
                'index' => 'partner',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );
        
        return parent::_prepareColumns();
    }

    /**
     * @return array|mixed|string|null
     */
    public function getGridUrl()
    {

        return $this->getData('grid_url') ?
            $this->getData('grid_url') :
            $this->getUrl('*/*/tartanGrid', ['_current' => true]);
    }

    /**
     * @return int[]|string[]
     * @throws LocalizedException
     */
    public function _getSelectedTartans()
    {

        $blocks = $this->clanManager->create()->getTartans($this->getRequest()->getParam('entity_id'));
        $tartans = [];
        $flag = 0;
        foreach ($blocks as $id) {
            $tartans[] = $id['tartan_entity_id'];
        }

        return $tartans;
    }

    /**
     * @return int[]|string[]
     * @throws LocalizedException
     */
    public function _getSelectedBlocks()
    {

        $blocks = $this->clanManager->create()->getTartans($this->getRequest()->getParam('entity_id'));
        if (!is_array($blocks)) {
            $blocks = array_keys($this->getRuleBlocks());
        }

        return $blocks;
    }

    /**
     * @return array
     */
    public function getRuleBlocks()
    {
        $id = $this->getRequest()->getParam('entity_id');
        $blocksArr = [];
        foreach ($this->coreRegistry->registry('current_clans_tartan')->getTartans($id) as $blocks) {
            $blocksArr[$blocks['entity_id']] = ['position' => '0'];
        }
        return $blocksArr;
    }
}
