<?php
namespace Mtc\Clans\Block\Adminhtml\Clan\Edit\Tab;

use Exception;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;
use Mtc\Clans\Model\ClanManagerFactory;

class Group extends Extended
{

    /**
     * Core registry
     *
     * @var Registry
     */
    private $coreRegistry = null;


    /**
     * @var ClanManagerFactory
     */
    private $clanManager;

    /**
     * @param Context $context
     * @param Data $backendHelper
     * @param ClanManagerFactory $clanManager
     * @param Registry $coreRegistry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $backendHelper,
        ClanManagerFactory $clanManager,
        Registry $coreRegistry,
        array $data = []
    ) {

        $this->clanManager = $clanManager;
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context, $backendHelper, $data);
    }

    /**
     * @return void
     * @throws FileSystemException
     */
    public function _construct()
    {
        parent::_construct();
        $this->setId('clans_group_grid');
        $this->setDefaultSort('clan_entity_id');
        $this->setUseAjax(true);
        if ($this->isReadonly()) {
            $this->setFilterVisibility(false);
        }
    }

    /**
     * @param $column
     * @return $this|Surname
     * @throws LocalizedException
     */
    protected function _addColumnFilterToCollection($column)
    {
        if ($column->getId() == 'in_groups') {
            $blockIds = $this->_getSelectedBlocks();
            if (empty($blockIds)) {
                $blockIds = 0;
            }

            if ($column->getFilter()->getValue()) {
                $this->getCollection()->addFieldToFilter('entity_id', ['in' => $blockIds]);
            } else {
                if ($blockIds) {
                    $this->getCollection()->addFieldToFilter('entity_id', ['nin' => $blockIds]);
                }
            }
        } else if ($column->getId() == 'clan_entity_id') {
            $this->getCollection()->addFieldToFilter('entity_id', $column->getFilter()->getCondition());
        } else if ($column->getId() == 'clan_group_name') {
            $this->getCollection()->addFieldToFilter('clan', $column->getFilter()->getCondition());
        }
        else {
            parent::_addColumnFilterToCollection($column);
        }

        return $this;
    }

    /**
     * Prepare collection
     *
     * @return Extended
     */
    protected function _prepareCollection()
    {
        $collection = $this->clanManager->create()
            ->getCollection()->addFieldToSelect('entity_id', 'clan_entity_id')->addFieldToSelect('clan', 'clan_group_name');

        if ($this->isReadonly()) {
            $blockIds = $this->_getSelectedBlocks();
            if (empty($blockIds)) {
                $blockIds = [0];
            }

            $collection->addFieldToFilter('clan_entity_id', ['in' => $blockIds]);
        }

        $this->setCollection($collection);
        return parent::_prepareCollection();
    }

    /**
     * @return mixed|null
     */
    protected function _getBlock()
    {
        return $this->coreRegistry->registry('current_clans_group');
    }

    /**
     * @return int
     */
    public function isReadonly()
    {
        return 0;
    }

    /**
     * @return Surname
     * @throws Exception
     */
    protected function _prepareColumns()
    {
        if (!$this->isReadonly()) {
            $this->addColumn(
                'in_groups',
                [
                    'type' => 'checkbox',
                    'name' => 'in_groups',
                    'values' => $this->_getSelectedBlocks(),
                    'align' => 'center',
                    'index' => 'clan_entity_id',
                    'header_css_class' => 'col-select',
                    'column_css_class' => 'col-select'
                ]
            );
        }

        $this->addColumn(
            'clan_entity_id',
            [
                'header' => __('Clan Id'),
                'sortable' => true,
                'index' => 'clan_entity_id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );

        $this->addColumn(
            'clan_group_name',
            [
                'header' => __('Clan'),
                'index' => 'clan_group_name',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );

        return parent::_prepareColumns();
    }

    /**
     * @return array|mixed|string|null
     */
    public function getGridUrl()
    {

        return $this->getData('grid_url') ?
            $this->getData('grid_url') :
            $this->getUrl('*/*/groupGrid', ['_current' => true]);
    }

    /**
     * @return int[]|string[]
     */
    public function _getSelectedBlocks()
    {
        $id = $this->getRequest()->getParam('entity_id');
        $blocks = $this->getGroups($id);
        if (!is_array($blocks)) {
            $blocks = array_keys($this->getRuleBlocks());
        }
        return $blocks;
    }


    /**
     * @return array
     */
    public function getRuleBlocks()
    {
        $id = $this->getRequest()->getParam('entity_id');
        $blocksArr = [];
        foreach ($this->coreRegistry->registry('current_clans_group')->getGroups($id) as $blocks) {
            $blocksArr[$blocks['clan_entity_id']] = ['position' => '0'];
        }
        return $blocksArr;
    }
}
