<?php
namespace Mtc\Clans\Block\Adminhtml\Clan\Edit;

use Exception;
use Magento\Backend\Block\Widget\Tabs as BackendTabs;
use Magento\Backend\Block\Template\Context ;
use Magento\Framework\Json\EncoderInterface;
use Magento\Backend\Model\Auth\Session;
use Magento\Framework\Registry;

/**
 * Admin page left menu
 */
class Tabs extends BackendTabs
{

    /**
     * @var Registry
     */
    private $coreRegistry;

    /**
     * @param Context $context
     * @param EncoderInterface $jsonEncoder
     * @param Session $authSession
     * @param Registry $coreRegistry
     * @param array $data
     */
    public function __construct(
        Context $context,
        EncoderInterface $jsonEncoder,
        Session $authSession,
        Registry $coreRegistry,
        array $data = []
    ) {
        $this->coreRegistry = $coreRegistry;
        parent::__construct($context, $jsonEncoder, $authSession, $data);
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('clan_tabs');
        $this->setDestElementId('edit_form');
        $this->setTitle(__('Clan Information'));
    }

    /**
     * @return void
     * @throws Exception
     */
    protected function _beforeToHtml()
    {
        $model = $this->coreRegistry->registry('clans_data');

        $this->addTab(
            'clan_surname',
            [
                'label' => __('Surnames'),
                'url' => $this->getUrl('*/*/surname', ['_current' => true]),
                'class' => 'ajax',
            ]
        );

        $this->addTab(
            'clan_tartan',
            [
                'label' => __('Tartans'),
                'url' => $this->getUrl('*/*/tartan', ['_current' => true]),
                'class' => 'ajax',
            ]
        );

        $this->addTab(
            'clan_group',
            [
                'label' => __('Clan Tartan Group'),
                'url' => $this->getUrl('*/*/group', ['_current' => true]),
                'class' => 'ajax',
            ]
        );

        parent::_beforeToHtml();
    }

}
