<?php
namespace Mtc\Clans\Controller\Adminhtml\Manage;

use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\Layout;
use Magento\Framework\View\Result\LayoutFactory;
use Mtc\Clans\Model\ClanManager;
use Magento\Framework\Registry;

class Group extends \Magento\Backend\App\Action
{

    /**
     * @var LayoutFactory
     */
    private $resultLayoutFactory;

    /**
     * @var ClanManager
     */
    private $clanManager;

    /**
     * @var Registry
     */
    private $registry;

    /**
     * @param Context $context
     * @param LayoutFactory $layoutFactory
     * @param ClanManager $clanManager
     * @param Registry $registry
     */
    public function __construct(
        Context $context,
        LayoutFactory $layoutFactory,
        ClanManager $clanManager,
        Registry $registry
    ) {
        $this->resultLayoutFactory = $layoutFactory;
        $this->clanManager = $clanManager;
        $this->registry = $registry;
        parent::__construct($context);
    }

    /**
     * @return ResponseInterface|ResultInterface|Layout
     */
    public function execute()
    {
        $resultLayout = $this->resultLayoutFactory->create();
        $this->_initGroup();

        $resultLayout->getLayout()
            ->getBlock('clan.edit.tab.group')
            ->setGroups($this->getRequest()->getPost('clan_group', null));
        return $resultLayout;
    }

    /**
     * @return ClanManager
     */
    protected function _initGroup()
    {
        $clan = $this->clanManager;
        $entityId = (int) $this->getRequest()->getParam('entity_id');
        if ($entityId) {
            $clan->load($entityId);
        }
        $this->registry->register('current_clans_group', $clan);
        return $clan;
    }
}
