<?php
namespace Mtc\ClansEvents\Api;

use Mtc\ClansEvents\Api\Data\EventManagerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Declared inter
 * interface EventsManagerRepositoryInterface
 */
interface EventManagerRepositoryInterface
{
    /**
     * Save clan.
     *
     * @param EventManagerInterface $event
     * @return mixed
     */
    public function save(EventManagerInterface $event);

    /**
     * Retrieve event.
     *
     * @param $eventId
     * @return mixed
     */
    public function getById($eventId);

    /**
     * Retrieve list matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return mixed
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete tartan.
     *
     * @param EventManagerInterface $clan
     * @return mixed
     */
    public function delete(EventManagerInterface $clan);

    /**
     * Delete event by ID.
     *
     * @param $eventId
     * @return mixed
     */
    public function deleteById($eventId);

}
