<?php
namespace Mtc\ClansEvents\Ui\DataProvider\Event\Form\Modifier;

use Magento\Framework\Exception\LocalizedException;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class Details extends Modifier implements ModifierInterface
{

    /**
     * @param array $meta
     * @return array
     */
    public function modifyMeta(array $meta)
    {
        return $meta;
    }

    /**
     * @param array $data
     * @return array
     */
    public function modifyData(array $data)
    {
        $id = $this->getEvent()->getId();
        if (!empty($data[$id]['thumbnail_image'])) {
            $data[$id]['thumbnail_image'] = [
                [
                    'name' => $this->getEvent()->getThumbnailImage(),
                    'url'  => $this->getEvent()->getThumbnailImageUrl(),
                    'file' => $this->getEvent()->getThumbnailImage()
                ]
            ];
        }
        return $data;
    }
}
