<?php
namespace Mtc\ClansEvents\Controller\Adminhtml\Manage;

use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\PageFactory;
use Mtc\ClansEvents\Api\EventManagerRepositoryInterface;
use Magento\Backend\App\Action\Context;
use Magento\Backend\App\Action;
use Mtc\ClansEvents\Model\EventManagerFactory;

class Edit extends Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Mtc_ClansEvents::manage_event';

    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var EventManagerRepositoryInterface
     */
    private $eventManagerRepositoryInterface;

    /**
     * Core registry
     *
     * @var Registry
     */
    private $coreRegistry = null;

    /**
     * @var EventManagerFactory
     */
    private $clanManager;

    /**
     * Edit constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param EventManagerRepositoryInterface $eventManagerRepositoryInterface
     * @param Registry $registry
     * @param EventManagerFactory $clanManager
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        EventManagerRepositoryInterface $eventManagerRepositoryInterface,
        Registry $registry,
        EventManagerFactory $clanManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->eventManagerRepositoryInterface = $eventManagerRepositoryInterface;
        $this->coreRegistry = $registry;
        $this->clanManager = $clanManager;
        parent::__construct($context);
    }

    /**
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('event_id');
        $model = $id?$this->eventManagerRepositoryInterface->getById($id):$this->clanManager->create();
        $this->coreRegistry->register('events_data', $model);
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mtc_ClansEvents::event')
            ->addBreadcrumb(__('Events'), __('Events'))
            ->addBreadcrumb(__('Manage Events'), __('Manage Events'));
        $resultPage->addBreadcrumb(
            $id ? __('Edit Event') : __('New Event'),
            $id ? __('Edit Event') : __('New Event')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Events'));
        $resultPage->getConfig()->getTitle()
            ->prepend($id ? $model->getEventTitle() : __('New Event'));
        return $resultPage;
    }
}
