<?php
namespace Mtc\ClansEvents\Model\ResourceModel;

use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Psr\Log\LoggerInterface;
use Mtc\ClansEvents\Api\Data\EventManagerInterface;
use Magento\Framework\EntityManager\EntityManager;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Backend\Helper\Js;

class EventManager extends AbstractDb
{
    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @var MetadataPool
     */
    protected $metadataPool;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Js
     */
    private $helperJs;

    /**
     * @param Context $context
     * @param LoggerInterface $logger
     * @param EntityManager $entityManager
     * @param MetadataPool $metadataPool
     * @param Js $helperJs
     * @param null $connectionName
     */
    public function __construct(
        Context $context,
        LoggerInterface $logger,
        EntityManager $entityManager,
        MetadataPool $metadataPool,
        Js $helperJs,
        $connectionName = null
    ) {
        $this->logger = $logger;
        $this->entityManager = $entityManager;
        $this->metadataPool = $metadataPool;
        $this->helperJs = $helperJs;
        parent::__construct($context, $connectionName);
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init('mtc_clans_events', 'event_id');
    }

    /**
     * @inheritDoc
     */
    public function getConnection()
    {
        return $this->metadataPool->getMetadata(EventManagerInterface::class)->getEntityConnection();
    }

    /**
     * @param AbstractModel $object
     * @return $this
     */
    public function save(AbstractModel $object)
    {
        try {
            $this->entityManager->save($object);
            $links = $object['links'];
            if (isset($links['clans'])) {
                $clanIds = [];
                foreach ($links['clans'] as $clan) {
                    $clanIds[] = $clan['id'];
                }
                if ($clanIds) {
                    $condition = $this->getConnection()
                        ->quoteInto('event_id = ?', $object->getEventId());

                    $this->getConnection()
                        ->delete($this->getTable('mtc_event_clan_link'), $condition);

                    foreach ($clanIds as $id) {
                        $blocks = [];
                        $blocks['event_id'] = $object->getEventId();
                        $blocks['clan_id'] = $id;
                        $this->getConnection()
                            ->insert($this->getTable('mtc_event_clan_link'), $blocks);
                    }
                }
            }
            return $this;
        } catch (\Exception $exception) {
            $this->logger->critical($exception->getMessage());
        }
    }

    /**
     * @param AbstractModel $object
     * @return $this|EventManager
     */
    public function delete(AbstractModel $object)
    {
        try {
            $this->entityManager->delete($object);
            return $this;
        } catch (\Exception $exception) {
            $this->logger->debug($exception->getMessage());
        }
    }
}
