<?php
namespace Mtc\ClansEvents\Model;

use Magento\Framework\Exception\LocalizedException;
use Mtc\ClansEvents\Api\Data\EventManagerInterface;
use Mtc\ClansEvents\Model\ResourceModel\EventManager as EventManagerResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractExtensibleModel;
use Mtc\ClansEvents\Model\Image as ImageModel;
use Magento\Framework\UrlInterface;

/**
 * Class EventManager
 * @package Mtc\ClansEvents\Model
 * @method ImageModel getImageModel()
 * @method UrlInterface getUrlBuilder()
 */
class EventManager extends AbstractExtensibleModel implements EventManagerInterface, IdentityInterface
{
    const STATUS_ENABLED = 1;
    const STATUS_DISABLED = 0;

    /**
     * @var PAGE_CACHE
     */
    const CACHE_TAG = 'mtc_event_manager';

    /**
     * @var PAGE_CACHE|string
     */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * Constructor to initialize ResourceModel
     */
    public function _construct()
    {
        $this->_init(EventManagerResourceModel::class);
    }

    /**
     * Return unique ID(s) for each object in system
     *
     * @return string[]
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId(), self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * Prepare clan's shop statuses.
     *
     *
     * @return array
     */
    public function getAvailableStatuses()
    {
        return [self::STATUS_ENABLED => __('Yes'), self::STATUS_DISABLED => __('No')];
    }

    /**
     * @param int $entityId
     * @return $this
     */
    public function setEventId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return int
     */
    public function getEventId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param string $eventTitle
     * @return $this
     */
    public function setEventTitle($eventTitle)
    {
        return $this->setData(self::EVENT_TITLE, $eventTitle);
    }

    /**
     * @return string
     */
    public function getEventTitle()
    {
        return $this->getData(self::EVENT_TITLE);
    }

    /**
     * @param string $callForRepresenters
     * @return $this
     */
    public function setCallForRepresenters($callForRepresenters)
    {
        return $this->setData(self::CALL_FOR_REPRESENTERS, $callForRepresenters);
    }

    /**
     * @return string
     */
    public function getCallForRepresenters()
    {
        return $this->getData(self::CALL_FOR_REPRESENTERS);
    }

    /**
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        return $this->setData(self::DESCRIPTION, $description);
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->getData(self::DESCRIPTION);
    }

    /**
     * @param string $thumbnailImage
     * @return $this
     */
    public function setThumbnailImage($thumbnailImage)
    {
        return $this->setData(self::THUMBNAIL_IMAGE, $thumbnailImage);
    }

    /**
     * @return string
     */
    public function getThumbnailImage()
    {
        return $this->getData(self::THUMBNAIL_IMAGE);
    }

    /**
     * @param string $isActive
     * @return $this
     */
    public function setIsActive($isActive)
    {
        return $this->setData(self::IS_ACTIVE, $isActive);
    }

    /**
     * @return string
     */
    public function getIsActive()
    {
        return $this->getData(self::IS_ACTIVE);
    }

    /**
     * @param string $date
     * @return $this
     */
    public function setDate($date)
    {
        return $this->setData(self::DATE, $date);
    }

    /**
     * @return string
     */
    public function getDate()
    {
        return $this->getData(self::DATE);
    }

    /**
     * @param string $createdAt
     * @return $this
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @param string $updatedAt
     * @return $this
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT);
    }

    /**
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * @return string
     */
    public function getThumbnailImageUrl()
    {
        return $this->getImageModel()->getBaseUrl()
            . '/' . ltrim($this->getThumbnailImage(), '/');
    }

    /**
     * @param $eventId
     * @return array|null
     * @throws LocalizedException
     */
    public function getClans($eventId)
    {
        $blockTable = $this->getResource()->getTable('mtc_event_clan_link');
        $surnameTable = $this->getResource()->getTable('mtc_clan');
        $collection = $this->getResourceCollection()
            ->addFieldToFilter('main_table.event_id', $eventId);
        $collection->getSelect()
            ->joinLeft(['clanLink' => $blockTable], 'clanLink.event_id = main_table.event_id')
            ->joinLeft(['clanTable' => $surnameTable], 'clanTable.entity_id = clanLink.clan_id')
            ->order('main_table.event_id');

        return $collection->getData();
    }
}
