<?php
namespace Mtc\ClansEvents\Model\ResourceModel\EventManager;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Mtc\ClansEvents\Model\EventManager as EventManagerModel;
use Mtc\ClansEvents\Model\ResourceModel\EventManager as EventManagerResourceModel;
use Magento\Framework\Api\Search\AggregationInterface;

class Collection extends AbstractCollection implements SearchResultInterface
{
    /**
     * @var string
     */
    protected $_idFieldName = 'event_id';

    /**
     * Event prefix
     * @var string
     */
    private $eventPrefix = 'event_manager_grid_collection';

    /**
     * Event object
     * @var string
     */
    private $eventObject = 'event_manage_grid_collection';

    /**
     * @var
     */
    private $aggregations;

    /**
     * Initialization of Model and ResourceModel
     */
    public function _construct()
    {
        $this->_init(
            EventManagerModel::class,
            EventManagerResourceModel::class
        );
        $this->_map['fields']['event_id'] = 'main_table.event_id';
    }

    /**
     * @return AggregationInterface
     */

    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * @param AggregationInterface $aggregations
     * @return $this
     */
    public function setAggregations($aggregations)
    {
        $this->aggregations = $aggregations;
    }

    /**
     * @return int
     */
    public function getTotalCount()
    {
        return $this->getSize();
    }

    /**
     * @param int $totalCount
     * @return $this|SearchResultInterface
     */
    public function setTotalCount($totalCount)
    {
        return $this;
    }

    /**
     * @param array|null $items
     * @return $this|SearchResultInterface
     */
    public function setItems(array $items = null)
    {
        return $this;
    }

    /**
     * @return SearchCriteriaInterface|null
     */
    public function getSearchCriteria()
    {
        return null;
    }

    /**
     * @param SearchCriteriaInterface|null $searchCriteria
     * @return SearchResultInterface
     */
    public function setSearchCriteria(SearchCriteriaInterface $searchCriteria = null)
    {
        return $this;
    }
}
