<?php
namespace Mtc\ClansEvents\Ui\DataProvider\Event\Form;

use Mtc\ClansEvents\Model\EventManager;
use Mtc\ClansEvents\Model\ResourceModel\EventManager\CollectionFactory as EventCollectionFactory;
use Mtc\ClansEvents\Ui\DataProvider\Event\Form\Modifier\Modifier;
use Magento\Ui\DataProvider\AbstractDataProvider;
use Magento\Ui\DataProvider\Modifier\PoolInterface;

class EventDataProvider extends AbstractDataProvider
{
    /**
     * @var PoolInterface
     */
    private $pool;

    /**
     * ProductsetDataProvider constructor.
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param EventCollectionFactory $collectionFactory
     * @param PoolInterface $pool
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        EventCollectionFactory $collectionFactory,
        PoolInterface $pool,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collectionFactory->create();
        $this->pool = $pool;
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);

    }

    /**
     * @return EventManager
     */
    public function getEvent()
    {
        static $event;
        if (!isset($event)) {
            $event = $this->getCollection()->getFirstItem();
        }
        return $event;
    }

    /**
     * {@inheritdoc}
     */
    public function getData()
    {
        /** @var EventManager $event */
        $event = $this->getEvent();
        $data[$event->getEventId()] = $event->getData();

        /** @var Modifier $modifier */
        foreach ($this->pool->getModifiersInstances() as $modifier) {
            $modifier->setEvent($event);
            $data = $modifier->modifyData($data);
        }

        return $data;
    }

    /**
     * {@inheritdoc}
     */
    public function getMeta()
    {
        $meta = parent::getMeta();
        /** @var Modifier $modifier */
        foreach ($this->pool->getModifiersInstances() as $modifier) {
            $meta = $modifier->modifyMeta($meta);
        }
        return $meta;
    }
}
