<?php
namespace Mtc\ClansEvents\Controller\Detail;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\View\Result\PageFactory;
use Mtc\ClansEvents\Api\EventManagerRepositoryInterface;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Controller\ResultFactory;

class Index extends Action
{
    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var EventManagerRepositoryInterface
     */
    private $eventManagerRepository;

    /**
     * @var ResultFactory
     */
    private $result;

    /**
     * @var ManagerInterface
     */
    private $managerInterface;

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param EventManagerRepositoryInterface $eventManagerRepository
     * @param ResultFactory $result
     * @param ManagerInterface $managerInterface
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        EventManagerRepositoryInterface $eventManagerRepository,
        ResultFactory $result,
        ManagerInterface $managerInterface
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->eventManagerRepository = $eventManagerRepository;
        $this->result = $result;
        $this->managerInterface = $managerInterface;
    }

    /**
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        $eventId = $this->_request->getParam('id');
        if (isset($eventId)) {
            $event = $this->eventManagerRepository->getById($eventId);
            if (empty($event->getData())) {
                $this->managerInterface->addErrorMessage(__('No event exsit with ' .$eventId . ' id'));
                $resultRedirect = $this->result->create(ResultFactory::TYPE_REDIRECT);
                $norouteUrl = $this->_url->getUrl('noroute');
                $resultRedirect->setUrl($norouteUrl);
                return $resultRedirect;
            }
        } elseif (!isset($eventId)) {
            $resultRedirect = $this->result->create(ResultFactory::TYPE_REDIRECT);
            $norouteUrl = $this->_url->getUrl('noroute');
            $resultRedirect->setUrl($norouteUrl);
            return $resultRedirect;
        }
        return $this->resultPageFactory->create();
    }
}
