<?php
namespace Mtc\ClansEvents\Model;

use Magento\Framework\UrlInterface;
use Magento\Framework\Filesystem;

class Image
{
    const BASEDIR = 'EventManager';

    /**
     * url builder
     *
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * @var Filesystem
     */
    protected $fileSystem;

    /**
     * @param UrlInterface $urlBuilder
     * @param Filesystem $fileSystem
     */
    public function __construct(
        UrlInterface $urlBuilder,
        Filesystem $fileSystem
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->fileSystem = $fileSystem;
    }

    /**
     * get images base url
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->urlBuilder
                ->getBaseUrl(['_type' => UrlInterface::URL_TYPE_MEDIA]) ;
    }

}
