<?php
namespace Mtc\Finder\Controller\Adminhtml\Manage;

use Magento\Framework\App\ResponseInterface as ResponseInterfaceAlias;
use Magento\Framework\Controller\Result\Redirect as RedirectAlias;
use Magento\Framework\Controller\ResultInterface as ResultInterfaceAlias;
use Magento\Framework\View\Result\PageFactory;
use Mtc\Finder\Api\TartanManagerRepositoryInterface;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Backend\App\Action;

/**
 * This Class is used to add new or update existing record
 *
 * Class Edit
 */
class Edit extends Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    const ADMIN_RESOURCE = 'Mtc_Finder::manage_tartan';

    /**
     * @var PageFactory
     */
    private $resultPageFactory;

    /**
     * @var TartanManagerRepositoryInterface
     */
    private $eventManagerRepositoryInterface;

    /**
     * Edit constructor.
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param TartanManagerRepositoryInterface $eventManagerRepositoryInterface
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        TartanManagerRepositoryInterface $eventManagerRepositoryInterface
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->eventManagerRepositoryInterface = $eventManagerRepositoryInterface;
        parent::__construct($context);
    }

    /**
     * Edit CMS page
     * @return ResultInterfaceAlias
     */
    public function execute()
    {
        // 1. Get ID and create model and breadcrumbs
        $id = $this->getRequest()->getParam('entity_id');
        $model = $id?$this->eventManagerRepositoryInterface->getById($id):null;
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Mtc_Finder::tartan')
            ->addBreadcrumb(__('Tartan'), __('Tartan'))
            ->addBreadcrumb(__('Manage Tartan'), __('Manage Tartan'));
        $resultPage->addBreadcrumb(
            $id ? __('Edit Tartan') : __('New Tartan'),
            $id ? __('Edit Tartan') : __('New Tartan')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Tartans'));
        $resultPage->getConfig()->getTitle()
            ->prepend($id ? $model->getName() : __('New Tartan'));
        return $resultPage;
    }
}
