<?php
namespace Mtc\Finder\Plugin;

use Magento\Catalog\Model\Product;
use Magento\Framework\App\Request\Http;

class AddTartanIdToProduct
{

    private $request;

    public function __construct(
        Http $request
    ) {
        $this->request = $request;
    }

    public function afterGetProductUrl(Product $subject, $result)
    {
        if ($this->request->getParam('tartan')) {
            $params = ['tartan' => $this->request->getParam('tartan'), 'catId' => $subject->getCategoryId()];
            $urlParams = [];
            foreach ($params as $name=>$value){
                $urlParams[] = $name.'='.urlencode($value);
            }
            $urlParams = implode('&', $urlParams);
            if ($urlParams){
                $glue = '?';
                if (str_contains($result, $glue)){
                    $glue = '&';
                }
                $result .= $glue.$urlParams;
            }
        }
        if ($this->request->getParam('clan')) {
            $params = ['clan' => $this->request->getParam('clan'), 'catId' => $subject->getCategoryId()];
            $urlParams = [];
            foreach ($params as $name=>$value){
                $urlParams[] = $name.'='.urlencode($value);
            }
            $urlParams = implode('&', $urlParams);
            if ($urlParams){
                $glue = '?';
                if (str_contains($result, $glue)){
                    $glue = '&';
                }
                $result .= $glue.$urlParams;
            }
        }
        return $result;
    }
}
